/*
*******************************************************************************
*
* File:         physical.h
* Description:
* Author:       Henrik Liebau, BVS R&D
* Created:      1998
* Modified:     Tue Dec 18 13:35:52 2001 by Henrik Liebau, BVS R&D
* Language:     C++
* Package:      HP E2920A Series Memory driver
* Status:       
*
* (C) Copyright 2000, Agilent Technologies GmbH, All Rights Reserved.
* (C) Copyright 1998, 1999, Hewlett-Packard GmbH, All Rights Reserved.
*
*******************************************************************************
*/

#ifndef _PHYSICAL_H_
#define _PHYSICAL_H_

#  include <b_pci.h>

#if defined(_WIN32) || defined(_WIN64)
#  include <windows.h>
#  define BEST_IO_READ_BYTE   BEST_NTMEM_IO_READ_BYTE
#  define BEST_IO_READ_WORD   BEST_NTMEM_IO_READ_WORD
#  define BEST_IO_READ_DWORD  BEST_NTMEM_IO_READ_DWORD
#  define BEST_IO_WRITE_BYTE  BEST_NTMEM_IO_WRITE_BYTE
#  define BEST_IO_WRITE_WORD  BEST_NTMEM_IO_WRITE_WORD
#  define BEST_IO_WRITE_DWORD BEST_NTMEM_IO_WRITE_DWORD
#else  /* not defined WIN32 */

typedef enum _b_io_cmds_type {
  BEST_IO_READ_BYTE = 1,
  BEST_IO_READ_WORD,
  BEST_IO_READ_DWORD,
  BEST_IO_WRITE_BYTE,
  BEST_IO_WRITE_WORD,
  BEST_IO_WRITE_DWORD
} b_io_cmds_type;

#endif /* defined WIN32 */

#ifndef HUGEP
#  ifdef _DOS
#    ifndef DOSW32
#      define HUGEP __huge
#    else /* DOSW32 is defined */
#      define HUGEP
#    endif /* DOSW32 */
#  else
#    define HUGEP
#  endif /* defined DOS */
#endif /* not defined HUGEP */

#include <stddef.h>

/*-------------------------------------------------------------------------
 * functions from physical.c
 * located in
 * ../ntdrv/mem : Windows NT/2000
 * ../capi      : DOS (named physdos.c)
 * ------------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

/*-------------------- allocation / deallocation of memory buffers ----------*/
int allocate_physical_memory( size_t size,
			      void HUGEP * HUGEP * virtual_addr,
                              SPhysicalAddress * physical_addr );

int free_physical_memory(void HUGEP * virtual_addr);

/*---------------------------------------------------------------------------*
 * typedef struct SPhysicalMemory
 *
 * Purpose	: used for allocating memory. Make sure you initialize
 *                member m_memSize for the desired buffer size.
 *---------------------------------------------------------------------------*/
typedef struct {
  size_t           m_memSize;
  void HUGEP *     m_pVirtualAddr;
  SPhysicalAddress m_physicalAddr;
#if _WIN32_WINNT >= 0x0500
  PULONG_PTR       m_pReserved;		/* used by Win2K currently */
#endif /* _WIN32_WINNT >= 0x0500 */
} SPhysicalMemory;

int AllocatePhysicalMemory ( SPhysicalMemory * pPhysicalMemory );
int DeAllocatePhysicalMemory ( SPhysicalMemory * pPhysicalMemory );
 
/*-------------------- physical/virtual mapping -----------------------------*/
void HUGEP * map_physical_address( unsigned long phys_addr_low,
				   unsigned long phys_addr_hi,
				   unsigned long length,
				   unsigned int bus_number, unsigned int io );

void unmap_physical_address( void HUGEP * virt_addr );

// unsigned long virtual_to_physical(unsigned long addr);

/*-------------------- I/O space access -------------------------------------*/
int io_access(int cmd, __int64 addr, unsigned long *data);


/*-------------------- reboot the DUT ---------------------------------------*/
void RebootDUT(void);

/*-------------------- Interrupt test ---------------------------------------*/
unsigned short StartInterruptTest(unsigned short devID, unsigned char statusOffset);
unsigned long EndInterruptTest(void);


#ifdef __cplusplus
}
#endif

#endif
